package com.firedictionary.eclipse.wizard.codegen.xul.template;

import com.firedictionary.eclipse.wizard.codegen.xul.wizards.InputValues;

/**
 * Copyright (C) 2005 Noriaki Hamamoto <firedictionary@gmail.com>
 * 
 * This file is part of Codegen for Xul project in Eclipse.
 *
 * Codegen for Xul project in Eclipse is free software; you can 
 * redistribute it and/or modify it under the terms of the GNU 
 * General Public License as published by the Free Software Foundation;
 * either version 2 of the License, or (at your option) any later
 * version.
 *
 * Codegen for Xul project in Eclipse is distributed in the hope
 * that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Codegen for Xul project in Eclipse; if not, write to
 * the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA  02111-1307  USA
 */
 
 public class ChromeManifestGenerator
 {
  protected final String NL = System.getProperties().getProperty("line.separator");
  protected final String TEXT_1 = "content ";
  protected final String TEXT_2 = " jar:chrome/";
  protected final String TEXT_3 = ".jar!/content/";
  protected final String TEXT_4 = NL + "locale ";
  protected final String TEXT_5 = " ";
  protected final String TEXT_6 = " jar:chrome/";
  protected final String TEXT_7 = ".jar!/locale/";
  protected final String TEXT_8 = "/";
  protected final String TEXT_9 = NL + "skin ";
  protected final String TEXT_10 = " classic/1.0 jar:chrome/";
  protected final String TEXT_11 = ".jar!/skin/classic/";

   public String generate(Object argument)
  {
    StringBuffer stringBuffer = new StringBuffer();
     InputValues values = (InputValues)argument; 
     if ( values.isContent() ) { 
    stringBuffer.append(TEXT_1);
    stringBuffer.append(values.getProjectName());
    stringBuffer.append(TEXT_2);
    stringBuffer.append(values.getProjectName());
    stringBuffer.append(TEXT_3);
     } 
     if ( values.isLocale() ) { 
    stringBuffer.append(TEXT_4);
    stringBuffer.append(values.getProjectName());
    stringBuffer.append(TEXT_5);
    stringBuffer.append(values.getLocaleName());
    stringBuffer.append(TEXT_6);
    stringBuffer.append(values.getProjectName());
    stringBuffer.append(TEXT_7);
    stringBuffer.append(values.getLocaleName());
    stringBuffer.append(TEXT_8);
     } 
     if ( values.isSkin() ) { 
    stringBuffer.append(TEXT_9);
    stringBuffer.append(values.getProjectName());
    stringBuffer.append(TEXT_10);
    stringBuffer.append(values.getProjectName());
    stringBuffer.append(TEXT_11);
     } 
    return stringBuffer.toString();
  }
}