package com.firedictionary.eclipse.wizard.codegen.xul.template;

import com.firedictionary.eclipse.wizard.codegen.xul.wizards.InputValues;

/**
 * Copyright (C) 2005 Noriaki Hamamoto <firedictionary@gmail.com>
 * 
 * This file is part of Codegen for Xul project in Eclipse.
 *
 * Codegen for Xul project in Eclipse is free software; you can 
 * redistribute it and/or modify it under the terms of the GNU 
 * General Public License as published by the Free Software Foundation;
 * either version 2 of the License, or (at your option) any later
 * version.
 *
 * Codegen for Xul project in Eclipse is distributed in the hope
 * that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Codegen for Xul project in Eclipse; if not, write to
 * the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA  02111-1307  USA
 */
 
 public class InstallRdfGenerator
 {
  protected final String NL = System.getProperties().getProperty("line.separator");
  protected final String TEXT_1 = "<?xml version=\"1.0\"?>" + NL + "" + NL + "<RDF xmlns=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\"" + NL + "     xmlns:em=\"http://www.mozilla.org/2004/em-rdf#\">" + NL + "" + NL + "  <Description about=\"urn:mozilla:install-manifest\">" + NL + "    <em:id>{00000000-0000-0000-0000-000000000000}</em:id>" + NL + "    <em:version>0.1</em:version>" + NL + "    <em:type>2</em:type>" + NL + "    " + NL + "    <!-- Target Application this extension can install into, " + NL + "        with minimum and maximum supported versions. --> " + NL + "    <em:targetApplication>" + NL + "      <Description>" + NL + "        <em:id>{ec8030f7-c20a-464f-9b0e-13a3a9e97384}</em:id>" + NL + "        <em:minVersion>2.0</em:minVersion>" + NL + "        <em:maxVersion>2.0.0.*</em:maxVersion>" + NL + "      </Description>" + NL + "    </em:targetApplication>" + NL + "    " + NL + "    <!-- Front End MetaData -->" + NL + "    <em:name>";
  protected final String TEXT_2 = "</em:name>" + NL + "    <em:description>XUL extention</em:description>" + NL + "    <em:creator>";
  protected final String TEXT_3 = "</em:creator>" + NL + "    <em:homepageURL>http://www.";
  protected final String TEXT_4 = ".com/</em:homepageURL>" + NL + "    <!--<em:updateURL>http://www.";
  protected final String TEXT_5 = ".com/software/mb/umo/update.rdf</em:updateURL>-->" + NL + "" + NL + "    <!-- Front End Integration Hooks (used by Extension Manager)-->" + NL + "    <!--<em:optionsURL>chrome://";
  protected final String TEXT_6 = "/content/options.xul</em:optionsURL>-->" + NL + "    <!--<em:aboutURL>chrome://";
  protected final String TEXT_7 = "/content/options.xul</em:aboutURL>-->" + NL + "    <!--<em:iconURL>chrome://";
  protected final String TEXT_8 = "/skin/newext2.png</em:iconURL>-->" + NL + "    " + NL + "    <!-- Packages, Skins and Locales that this extension registers -->" + NL + "    <em:file>" + NL + "      <Description about=\"urn:mozilla:extension:file:";
  protected final String TEXT_9 = ".jar\">";
  protected final String TEXT_10 = NL + "        <em:package>content/";
  protected final String TEXT_11 = "/</em:package>";
  protected final String TEXT_12 = NL + "        <em:locale>locale/";
  protected final String TEXT_13 = "/";
  protected final String TEXT_14 = "/</em:locale>";
  protected final String TEXT_15 = NL + "        <em:skin>skin/classic/";
  protected final String TEXT_16 = "/</em:skin>";
  protected final String TEXT_17 = NL + "      </Description>" + NL + "    </em:file>" + NL + "  </Description>" + NL + "</RDF>";

   public String generate(Object argument)
  {
    StringBuffer stringBuffer = new StringBuffer();
     InputValues values = (InputValues)argument; 
    stringBuffer.append(TEXT_1);
    stringBuffer.append(values.getDisplayName());
    stringBuffer.append(TEXT_2);
    stringBuffer.append(values.getAuther());
    stringBuffer.append(TEXT_3);
    stringBuffer.append(values.getProjectName());
    stringBuffer.append(TEXT_4);
    stringBuffer.append(values.getProjectName());
    stringBuffer.append(TEXT_5);
    stringBuffer.append(values.getProjectName());
    stringBuffer.append(TEXT_6);
    stringBuffer.append(values.getProjectName());
    stringBuffer.append(TEXT_7);
    stringBuffer.append(values.getProjectName());
    stringBuffer.append(TEXT_8);
    stringBuffer.append(values.getProjectName());
    stringBuffer.append(TEXT_9);
     if ( values.isContent() ) { 
    stringBuffer.append(TEXT_10);
    stringBuffer.append(values.getProjectName());
    stringBuffer.append(TEXT_11);
     } 
     if ( values.isLocale() ) { 
    stringBuffer.append(TEXT_12);
    stringBuffer.append(values.getLocaleName());
    stringBuffer.append(TEXT_13);
    stringBuffer.append(values.getProjectName());
    stringBuffer.append(TEXT_14);
     } 
     if ( values.isSkin() ) { 
    stringBuffer.append(TEXT_15);
    stringBuffer.append(values.getProjectName());
    stringBuffer.append(TEXT_16);
     } 
    stringBuffer.append(TEXT_17);
    return stringBuffer.toString();
  }
}