package com.firedictionary.eclipse.wizard.codegen.xul.template;

import com.firedictionary.eclipse.wizard.codegen.xul.wizards.InputValues;

/**
 * Copyright (C) 2005 Noriaki Hamamoto <firedictionary@gmail.com>
 * 
 * This file is part of Codegen for Xul project in Eclipse.
 *
 * Codegen for Xul project in Eclipse is free software; you can 
 * redistribute it and/or modify it under the terms of the GNU 
 * General Public License as published by the Free Software Foundation;
 * either version 2 of the License, or (at your option) any later
 * version.
 *
 * Codegen for Xul project in Eclipse is distributed in the hope
 * that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Codegen for Xul project in Eclipse; if not, write to
 * the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA  02111-1307  USA
 */
 
 public class InstallerGenerator
 {
  protected final String NL = System.getProperties().getProperty("line.separator");
  protected final String TEXT_1 = "initInstall(\"Install ";
  protected final String TEXT_2 = "\", \"";
  protected final String TEXT_3 = "\", \"0.1\");" + NL + "" + NL + "var targetFolder = getFolder(\"Chrome\");" + NL + "" + NL + "setPackageFolder(targetFolder);" + NL + "addFile(\"chrome/";
  protected final String TEXT_4 = ".jar\");" + NL + "" + NL + "targetFolder = getFolder(targetFolder, \"";
  protected final String TEXT_5 = ".jar\");" + NL;
  protected final String TEXT_6 = NL + "registerChrome(CONTENT | DELAYED_CHROME," + NL + "  targetFolder, \"content/";
  protected final String TEXT_7 = "/\");";
  protected final String TEXT_8 = NL + "registerChrome(LOCALE | DELAYED_CHROME," + NL + "  targetFolder, \"locale/";
  protected final String TEXT_9 = "/";
  protected final String TEXT_10 = "/\");";
  protected final String TEXT_11 = NL + "registerChrome(SKIN | DELAYED_CHROME," + NL + "  targetFolder, \"skin/classic/";
  protected final String TEXT_12 = "/\");";
  protected final String TEXT_13 = NL + NL + "if (0 == getLastError()){" + NL + "\t\t\t\tperformInstall();" + NL + "}else{" + NL + "\t   cancelInstall();" + NL + "}";

   public String generate(Object argument)
  {
    StringBuffer stringBuffer = new StringBuffer();
     InputValues values = (InputValues)argument; 
    stringBuffer.append(TEXT_1);
    stringBuffer.append(values.getDisplayName());
    stringBuffer.append(TEXT_2);
    stringBuffer.append(values.getProjectName());
    stringBuffer.append(TEXT_3);
    stringBuffer.append(values.getProjectName());
    stringBuffer.append(TEXT_4);
    stringBuffer.append(values.getProjectName());
    stringBuffer.append(TEXT_5);
     if ( values.isContent() ) { 
    stringBuffer.append(TEXT_6);
    stringBuffer.append(values.getProjectName());
    stringBuffer.append(TEXT_7);
     } 
     if ( values.isLocale() ) { 
    stringBuffer.append(TEXT_8);
    stringBuffer.append(values.getLocaleName());
    stringBuffer.append(TEXT_9);
    stringBuffer.append(values.getProjectName());
    stringBuffer.append(TEXT_10);
     } 
     if ( values.isSkin() ) { 
    stringBuffer.append(TEXT_11);
    stringBuffer.append(values.getProjectName());
    stringBuffer.append(TEXT_12);
     } 
    stringBuffer.append(TEXT_13);
    return stringBuffer.toString();
  }
}