package com.firedictionary.eclipse.wizard.codegen.xul.template;

import com.firedictionary.eclipse.wizard.codegen.xul.wizards.InputValues;

/**
 * Copyright (C) 2005 Noriaki Hamamoto <firedictionary@gmail.com>
 * 
 * This file is part of Codegen for Xul project in Eclipse.
 *
 * Codegen for Xul project in Eclipse is free software; you can 
 * redistribute it and/or modify it under the terms of the GNU 
 * General Public License as published by the Free Software Foundation;
 * either version 2 of the License, or (at your option) any later
 * version.
 *
 * Codegen for Xul project in Eclipse is distributed in the hope
 * that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Codegen for Xul project in Eclipse; if not, write to
 * the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA  02111-1307  USA
 */
 
 public class XulSampleGenerator
 {
  protected final String NL = System.getProperties().getProperty("line.separator");
  protected final String TEXT_1 = "<?xml version=\"1.0\"?>" + NL + "<?xml-stylesheet href=\"chrome://global/skin\" type=\"text/css\"?>" + NL + "" + NL + "<window title=\"";
  protected final String TEXT_2 = "\"" + NL + "\t\txmlns=\"http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul\">" + NL + "" + NL + "</window>";

   public String generate(Object argument)
  {
    StringBuffer stringBuffer = new StringBuffer();
     InputValues values = (InputValues)argument; 
    stringBuffer.append(TEXT_1);
    stringBuffer.append(values.getProjectName());
    stringBuffer.append(TEXT_2);
    return stringBuffer.toString();
  }
}