/*
 * Created on 2005/02/07
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package com.firedictionary.eclipse.wizard.codegen.xul.outcome;

import java.io.ByteArrayInputStream;
import java.io.InputStream;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

import com.firedictionary.eclipse.wizard.codegen.xul.template.RdfGenerator;
import com.firedictionary.eclipse.wizard.codegen.xul.wizards.InputValues;

/**
 * Copyright (C) 2005 Noriaki Hamamoto <firedictionary@gmail.com>
 * 
 * This file is part of Codegen for Xul project in Eclipse.
 *
 * Codegen for Xul project in Eclipse is free software; you can 
 * redistribute it and/or modify it under the terms of the GNU 
 * General Public License as published by the Free Software Foundation;
 * either version 2 of the License, or (at your option) any later
 * version.
 *
 * Codegen for Xul project in Eclipse is distributed in the hope
 * that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Codegen for Xul project in Eclipse; if not, write to
 * the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA  02111-1307  USA
 */


/**
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public abstract class AbstractPackageItem implements IPackageItem {
	protected IProgressMonitor monitor = null;	
	protected InputValues values;
	
	/**
	 * 
	 * @param monitor
	 * @param values TODO
	 */
	protected AbstractPackageItem(
			IProgressMonitor monitor, InputValues values
	){
		this.monitor = monitor;
		this.values = values;
	}
	
	/**
	 * 
	 * @param folder
	 * @param name
	 * @return
	 * @throws CoreException
	 */
	protected IFolder createFolder(
		IFolder folder,
		String name
	) throws CoreException{
		IFolder created = folder.getFolder(name);
		created.create(false, true, monitor);
		
		return created;
	}
	
	/**
	 * 
	 * @param folder
	 * @param name
	 * @return
	 * @throws CoreException
	 */
	protected IFile createEmptyFile(
		IFolder folder,
		String name
	) throws CoreException{		
		return createFile(folder, name, "");
		
	}
	
	/**
	 * 
	 * @param folder
	 * @return
	 * @throws CoreException
	 */
	protected IFile createRdfFile(IFolder folder) throws CoreException{
		RdfGenerator gen = new RdfGenerator();
		return createFile(folder, "contents.rdf", gen.generate(values));
	}
	
	/**
	 * Create new file with content specified as String class object.
	 * 
	 * @param folder
	 * @param name
	 * @param content
	 * @return file object which is created.
	 * @throws CoreException fatal error
	 */
	protected IFile createFile(
			IFolder folder, 
			String name, 
			String content
	) throws CoreException{
		IFile file = folder.getFile(name);
		InputStream is = new ByteArrayInputStream(content.getBytes());
		file.create(is, false, monitor);
		
		return file;
	}
	
	/**
	 * Create new file with content specified as String class object.
	 * 
	 * @param folder
	 * @param name
	 * @param content
	 * @return file object which is created.
	 * @throws CoreException fatal error
	 */
	protected IFile createFile(
			IProject project, 
			String name, 
			String content
	) throws CoreException{
		IFile file = project.getFile(name);
		InputStream is = new ByteArrayInputStream(content.getBytes());
		file.create(is, false, monitor);
		
		return file;
	}
}
