package com.firedictionary.eclipse.wizard.codegen.xul.wizards;

import java.lang.reflect.InvocationTargetException;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWizard;

import com.firedictionary.eclipse.wizard.codegen.xul.outcome.BuildXml;
import com.firedictionary.eclipse.wizard.codegen.xul.outcome.ChromeManifest;
import com.firedictionary.eclipse.wizard.codegen.xul.outcome.Content;
import com.firedictionary.eclipse.wizard.codegen.xul.outcome.IPackageItem;
import com.firedictionary.eclipse.wizard.codegen.xul.outcome.InstallJs;
import com.firedictionary.eclipse.wizard.codegen.xul.outcome.InstallRdf;
import com.firedictionary.eclipse.wizard.codegen.xul.outcome.Locale;
import com.firedictionary.eclipse.wizard.codegen.xul.outcome.Skin;

/**
 * Copyright (C) 2005 Noriaki Hamamoto <firedictionary@gmail.com>
 * 
 * This file is part of Codegen for Xul project in Eclipse.
 *
 * Codegen for Xul project in Eclipse is free software; you can 
 * redistribute it and/or modify it under the terms of the GNU 
 * General Public License as published by the Free Software Foundation;
 * either version 2 of the License, or (at your option) any later
 * version.
 *
 * Codegen for Xul project in Eclipse is distributed in the hope
 * that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Codegen for Xul project in Eclipse; if not, write to
 * the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA  02111-1307  USA
 */

/**
 * This is a sample new wizard. Its role is to create a new file 
 * resource in the provided container. If the container resource
 * (a folder or a project) is selected in the workspace 
 * when the wizard is opened, it will accept it as the target
 * container. The wizard creates one file with the extension
 * "mpe". If a sample multi-page editor (also available
 * as a template) is registered for the same extension, it will
 * be able to open it.
 */

public class XulNewWizard extends Wizard implements INewWizard {
	private XulNewWizardPage page;
	private ISelection selection;
	
	/**
	 * Constructor for XulNewWizard.
	 */
	public XulNewWizard() {
		super();
		setNeedsProgressMonitor(true);
	}
	
	/**
	 * Adding the page to the wizard.
	 */

	public void addPages() {
		page = new XulNewWizardPage(selection);
		addPage(page);
	}

	/**
	 * This method is called when 'Finish' button is pressed in
	 * the wizard. We will create an operation and run it
	 * using wizard as execution context.
	 */
	public boolean performFinish() {
		final InputValues values = page.getValues();
		IRunnableWithProgress op = new IRunnableWithProgress() {
			public void run(IProgressMonitor monitor) throws InvocationTargetException {
				try {
					doFinish(values, monitor);
				} catch (CoreException e) {
					throw new InvocationTargetException(e);
				} finally {
					monitor.done();
				}
			}
		};
		try {
			getContainer().run(true, false, op);
		} catch (InterruptedException e) {
			return false;
		} catch (InvocationTargetException e) {
			Throwable realException = e.getTargetException();
			MessageDialog.openError(getShell(), "Error", realException.getMessage());
			return false;
		}
		return true;
	}
	
	/**
	 * The worker method. It will find the container, create the
	 * file if missing or just replace its contents, and open
	 * the editor on the newly created file.
	 */
	
	private void doFinish(
		InputValues values,
		IProgressMonitor monitor
	)throws CoreException {
		IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
		IProject project = root.getProject(values.getProjectName());
		
		if(!project.exists()){
			project.create(monitor);
			project.open(monitor);
		}
		
		IFolder folder = project.getFolder("src");
		folder.create(false, true, monitor);
		
		if(values.isContent()){
			values.setPackageType("package");
			IPackageItem item = new Content(values, folder, monitor);
			item.generate();
		}
		
		if(values.isSkin()){
			values.setPackageType("skin");
			IPackageItem item = new Skin(values, folder, monitor);
			item.generate();
		}
		
		if(values.isLocale()){
			values.setPackageType("locale");
			IPackageItem item = new Locale(values, folder, monitor);
			item.generate();
		}
		
		// Generate build.xml
		IPackageItem item = new BuildXml(values, project, monitor);
		item.generate();
		
		// Generate install.js
		IPackageItem itemJs = new InstallJs(values, project, monitor);
		itemJs.generate();
		
		// Generate chrome.manifest
		/* Obsolated
		IPackageItem itemChromeManifest = new ChromeManifest(values, project, monitor);
		itemChromeManifest.generate();
		*/
		
		// Generate install.rdf
		IPackageItem itemInstallRdf = new InstallRdf(values, project, monitor);
		itemInstallRdf.generate();
		
		monitor.worked(1);
	}

	/**
	 * We will accept the selection in the workbench to see if
	 * we can initialize from it.
	 * @see IWorkbenchWizard#init(IWorkbench, IStructuredSelection)
	 */
	public void init(IWorkbench workbench, IStructuredSelection selection) {
		this.selection = selection;
	}
}