package com.firedictionary.eclipse.wizard.codegen.xul.template;

import com.firedictionary.eclipse.wizard.codegen.xul.wizards.InputValues;

/**
 * Copyright (C) 2005 Noriaki Hamamoto <firedictionary@gmail.com>
 * 
 * This file is part of Codegen for Xul project in Eclipse.
 *
 * Codegen for Xul project in Eclipse is free software; you can 
 * redistribute it and/or modify it under the terms of the GNU 
 * General Public License as published by the Free Software Foundation;
 * either version 2 of the License, or (at your option) any later
 * version.
 *
 * Codegen for Xul project in Eclipse is distributed in the hope
 * that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Codegen for Xul project in Eclipse; if not, write to
 * the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA  02111-1307  USA
 */
 
 public class RdfGenerator
 {
  protected final String NL = System.getProperties().getProperty("line.separator");
  protected final String TEXT_1 = "<?xml version=\"1.0\"?>" + NL + "<RDF:RDF xmlns:RDF=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\"" + NL + "         xmlns:chrome=\"http://www.mozilla.org/rdf/chrome#\">" + NL + "" + NL + "  <RDF:Seq about=\"urn:mozilla:";
  protected final String TEXT_2 = ":root\">" + NL + "    <RDF:li resource=\"urn:mozilla:";
  protected final String TEXT_3 = ":";
  protected final String TEXT_4 = "\"/>" + NL + "  </RDF:Seq>" + NL + "" + NL + "  <RDF:Description about=\"urn:mozilla:";
  protected final String TEXT_5 = ":";
  protected final String TEXT_6 = "\"" + NL + "        chrome:displayName=\"";
  protected final String TEXT_7 = "\"" + NL + "        chrome:author=\"";
  protected final String TEXT_8 = "\"" + NL + "        chrome:name=\"";
  protected final String TEXT_9 = "\">";
  protected final String TEXT_10 = NL + "    <chrome:packages>" + NL + "      <RDF:Seq about=\"urn:mozilla:";
  protected final String TEXT_11 = ":";
  protected final String TEXT_12 = ":packages\">" + NL + "        <RDF:li resource=\"urn:mozilla:";
  protected final String TEXT_13 = ":";
  protected final String TEXT_14 = ":";
  protected final String TEXT_15 = "\"/>" + NL + "      </RDF:Seq>" + NL + "    </chrome:packages>" + NL + "    ";
  protected final String TEXT_16 = NL + "  </RDF:Description>" + NL + "</RDF:RDF>";

   public String generate(Object argument)
  {
    StringBuffer stringBuffer = new StringBuffer();
    
 InputValues values = (InputValues)argument; 
 String packageType = new String();
 
 if( values.getPackageType() == "package" ) {
 	packageType = values.getProjectName();
 } else if ( values.getPackageType() == "locale" ) {
 	packageType = values.getLocaleName();
 } else if( values.getPackageType() == "skin" ) {
 	packageType = "classic/1.0";
 }

    stringBuffer.append(TEXT_1);
    stringBuffer.append(values.getPackageType());
    stringBuffer.append(TEXT_2);
    stringBuffer.append(values.getPackageType());
    stringBuffer.append(TEXT_3);
    stringBuffer.append(packageType);
    stringBuffer.append(TEXT_4);
    stringBuffer.append(values.getPackageType());
    stringBuffer.append(TEXT_5);
    stringBuffer.append(packageType);
    stringBuffer.append(TEXT_6);
    stringBuffer.append(values.getDisplayName());
    stringBuffer.append(TEXT_7);
    stringBuffer.append(values.getAuther());
    stringBuffer.append(TEXT_8);
    stringBuffer.append(packageType);
    stringBuffer.append(TEXT_9);
     if ( values.getPackageType() != "package" ) { 
    stringBuffer.append(TEXT_10);
    stringBuffer.append(values.getPackageType());
    stringBuffer.append(TEXT_11);
    stringBuffer.append(packageType);
    stringBuffer.append(TEXT_12);
    stringBuffer.append(values.getPackageType());
    stringBuffer.append(TEXT_13);
    stringBuffer.append(packageType);
    stringBuffer.append(TEXT_14);
    stringBuffer.append(values.getProjectName());
    stringBuffer.append(TEXT_15);
     } 
    stringBuffer.append(TEXT_16);
    return stringBuffer.toString();
  }
}