package com.firedictionary.eclipse.wizard.codegen.xul.wizards;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.IDialogPage;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Composite;

/**
 * Copyright (C) 2005 Noriaki Hamamoto <firedictionary@gmail.com>
 * 
 * This file is part of Codegen for Xul project in Eclipse.
 *
 * Codegen for Xul project in Eclipse is free software; you can 
 * redistribute it and/or modify it under the terms of the GNU 
 * General Public License as published by the Free Software Foundation;
 * either version 2 of the License, or (at your option) any later
 * version.
 *
 * Codegen for Xul project in Eclipse is distributed in the hope
 * that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Codegen for Xul project in Eclipse; if not, write to
 * the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA  02111-1307  USA
 */

/**
 * The "New" wizard page allows setting the container for the new file as well
 * as the file name. The page will only accept file name without the extension
 * OR with the extension that matches the expected one (mpe).
 */

public class XulNewWizardPage extends WizardPage {

	private ISelection selection;
	
	private XulNewWizardComposite container;
	private ModifyListener listenerTextboxes = null;
	private SelectionAdapter listenerCheckBoxes = null;
	
	/**
	 * Constructor for XulNewWizardPage.
	 * 
	 * @param pageName
	 */
	public XulNewWizardPage(ISelection selection) {
		super("wizardPage");
		setTitle("Xul project Wizard");
		setDescription("This wizard creates a new xul project in the workspace.");
		this.selection = selection;

		listenerTextboxes = new ModifyListener() {
			public void modifyText(ModifyEvent e) {
				dialogChanged();
			}
		};
		
		listenerCheckBoxes = new SelectionAdapter(){
			public void widgetSelected(SelectionEvent e) {    
				dialogChanged();
			}
		};
	}

	/**
	 * @see IDialogPage#createControl(Composite)
	 */
	public void createControl(Composite parent) {
		container = new XulNewWizardComposite(
				parent,
				SWT.NULL,
				listenerTextboxes,
				listenerCheckBoxes
		);
		
		dialogChanged();
		setControl(container);
	}

	/**
	 * Ensures that text field are set.
	 */

	private void dialogChanged() {
		InputValues values = getValues();
		
		String projectName = values.getProjectName();
		IResource container = ResourcesPlugin.getWorkspace().getRoot()
				.findMember(new Path(projectName));

		if (projectName.length() == 0) {
			updateStatus("Project name must be specified.");
			return;
		}
		if (!projectName.equals(projectName.toLowerCase())){
			updateStatus("Project name must consist of only small letters.");
			return;
		}
		if (container != null) {
			updateStatus("The name is already exist.");
			return;
		}
		if (values.getAuther().length() == 0) {
			updateStatus("Auther must be specified.");
			return;
		}
		if (values.getDisplayName().length() == 0) {
			updateStatus("Display name must be specified.");
			return;
		}
		if (!(values.isContent() || values.isSkin() || values.isLocale())){
			updateStatus("One of the check boxes should be selected.");
			return;
		}
		if (values.isLocale() && values.getLocaleName() == ""){
			updateStatus("A locale name should be specified when the locale is checked.");
			return;
		}
		
		updateStatus(null);
	}

	
	private void updateStatus(String message) {
		setErrorMessage(message);
		setPageComplete(message == null);
	}
	
	public InputValues getValues(){
		return container.getValues();
	}
}