/*
 * Decompiled with CFR 0.152.
 */
package com.firedictionary.eclipse.wizard.codegen.xul.wizards;

import com.firedictionary.eclipse.wizard.codegen.xul.outcome.AbstractPackageItem;
import com.firedictionary.eclipse.wizard.codegen.xul.outcome.BuildXml;
import com.firedictionary.eclipse.wizard.codegen.xul.outcome.Content;
import com.firedictionary.eclipse.wizard.codegen.xul.outcome.InstallJs;
import com.firedictionary.eclipse.wizard.codegen.xul.outcome.InstallRdf;
import com.firedictionary.eclipse.wizard.codegen.xul.outcome.Locale;
import com.firedictionary.eclipse.wizard.codegen.xul.outcome.Skin;
import com.firedictionary.eclipse.wizard.codegen.xul.wizards.InputValues;
import com.firedictionary.eclipse.wizard.codegen.xul.wizards.XulNewWizardPage;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class XulNewWizard
extends Wizard
implements INewWizard {
    private XulNewWizardPage page;
    private ISelection selection;

    public XulNewWizard() {
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.page = new XulNewWizardPage(this.selection);
        this.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        final InputValues values = this.page.getValues();
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    try {
                        XulNewWizard.this.doFinish(values, monitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            this.getContainer().run(true, false, op);
        }
        catch (InterruptedException e) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable realException = e.getTargetException();
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)realException.getMessage());
            return false;
        }
        return true;
    }

    private void doFinish(InputValues values, IProgressMonitor monitor) throws CoreException {
        AbstractPackageItem item;
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = root.getProject(values.getProjectName());
        if (!project.exists()) {
            project.create(monitor);
            project.open(monitor);
        }
        IFolder folder = project.getFolder("src");
        folder.create(false, true, monitor);
        if (values.isContent()) {
            values.setPackageType("package");
            item = new Content(values, folder, monitor);
            item.generate();
        }
        if (values.isSkin()) {
            values.setPackageType("skin");
            item = new Skin(values, folder, monitor);
            item.generate();
        }
        if (values.isLocale()) {
            values.setPackageType("locale");
            item = new Locale(values, folder, monitor);
            item.generate();
        }
        item = new BuildXml(values, project, monitor);
        item.generate();
        InstallJs itemJs = new InstallJs(values, project, monitor);
        itemJs.generate();
        InstallRdf itemInstallRdf = new InstallRdf(values, project, monitor);
        itemInstallRdf.generate();
        monitor.worked(1);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
    }
}

