/*
 * Decompiled with CFR 0.152.
 */
package com.firedictionary.eclipse.wizard.codegen.xul.wizards;

import com.firedictionary.eclipse.wizard.codegen.xul.wizards.InputValues;
import com.firedictionary.eclipse.wizard.codegen.xul.wizards.XulNewWizardComposite;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class XulNewWizardPage
extends WizardPage {
    private ISelection selection;
    private XulNewWizardComposite container;
    private ModifyListener listenerTextboxes = null;
    private SelectionAdapter listenerCheckBoxes = null;

    public XulNewWizardPage(ISelection selection) {
        super("wizardPage");
        this.setTitle("Xul project Wizard");
        this.setDescription("This wizard creates a new xul project in the workspace.");
        this.selection = selection;
        this.listenerTextboxes = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                XulNewWizardPage.this.dialogChanged();
            }
        };
        this.listenerCheckBoxes = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                XulNewWizardPage.this.dialogChanged();
            }
        };
    }

    public void createControl(Composite parent) {
        this.container = new XulNewWizardComposite(parent, 0, this.listenerTextboxes, this.listenerCheckBoxes);
        this.dialogChanged();
        this.setControl((Control)this.container);
    }

    private void dialogChanged() {
        InputValues values = this.getValues();
        String projectName = values.getProjectName();
        IResource container = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(projectName));
        if (projectName.length() == 0) {
            this.updateStatus("Project name must be specified.");
            return;
        }
        if (!projectName.equals(projectName.toLowerCase())) {
            this.updateStatus("Project name must consist of only small letters.");
            return;
        }
        if (container != null) {
            this.updateStatus("The name is already exist.");
            return;
        }
        if (values.getAuther().length() == 0) {
            this.updateStatus("Auther must be specified.");
            return;
        }
        if (values.getDisplayName().length() == 0) {
            this.updateStatus("Display name must be specified.");
            return;
        }
        if (!(values.isContent() || values.isSkin() || values.isLocale())) {
            this.updateStatus("One of the check boxes should be selected.");
            return;
        }
        if (values.isLocale() && values.getLocaleName() == "") {
            this.updateStatus("A locale name should be specified when the locale is checked.");
            return;
        }
        this.updateStatus(null);
    }

    private void updateStatus(String message) {
        this.setErrorMessage(message);
        this.setPageComplete(message == null);
    }

    public InputValues getValues() {
        return this.container.getValues();
    }
}

