/*
 * Decompiled with CFR 0.152.
 */
package com.firedictionary.eclipse.wizard.codegen.xul.outcome;

import com.firedictionary.eclipse.wizard.codegen.xul.outcome.IPackageItem;
import com.firedictionary.eclipse.wizard.codegen.xul.template.RdfGenerator;
import com.firedictionary.eclipse.wizard.codegen.xul.wizards.InputValues;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public abstract class AbstractPackageItem
implements IPackageItem {
    protected IProgressMonitor monitor = null;
    protected InputValues values;

    protected AbstractPackageItem(IProgressMonitor monitor, InputValues values) {
        this.monitor = monitor;
        this.values = values;
    }

    protected IFolder createFolder(IFolder folder, String name) throws CoreException {
        IFolder created = folder.getFolder(name);
        created.create(false, true, this.monitor);
        return created;
    }

    protected IFile createEmptyFile(IFolder folder, String name) throws CoreException {
        return this.createFile(folder, name, "");
    }

    protected IFile createRdfFile(IFolder folder) throws CoreException {
        RdfGenerator gen = new RdfGenerator();
        return this.createFile(folder, "contents.rdf", gen.generate(this.values));
    }

    protected IFile createFile(IFolder folder, String name, String content) throws CoreException {
        IFile file = folder.getFile(name);
        ByteArrayInputStream is = new ByteArrayInputStream(content.getBytes());
        file.create((InputStream)is, false, this.monitor);
        return file;
    }

    protected IFile createFile(IProject project, String name, String content) throws CoreException {
        IFile file = project.getFile(name);
        ByteArrayInputStream is = new ByteArrayInputStream(content.getBytes());
        file.create((InputStream)is, false, this.monitor);
        return file;
    }
}

