<?xml version="1.0" encoding="UTF-8" ?>

<!-- ***** BEGIN LICENSE BLOCK *****
   - Version: MPL 1.1/GPL 2.0/LGPL 2.1
   -
   - The contents of this file are subject to the Mozilla Public License Version
   - 1.1 (the "License"); you may not use this file except in compliance with
   - the License. You may obtain a copy of the License at
   - http://www.mozilla.org/MPL/
   -
   - Software distributed under the License is distributed on an "AS IS" basis,
   - WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
   - for the specific language governing rights and limitations under the
   - License.
   -
   - The Original Code is FireDictionary.
   -
   - The Initial Developer of the Original Code is
   - Noriaki Hamamoto <nori@firedictionary.com>.
   - Portions created by the Initial Developer are Copyright (C) 2005
   - the Initial Developer. All Rights Reserved.
   -
   - Contributor(s):
   -
   - Alternatively, the contents of this file may be used under the terms of
   - either the GNU General Public License Version 2 or later (the "GPL"), or
   - the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
   - in which case the provisions of the GPL or the LGPL are applicable instead
   - of those above. If you wish to allow use of your version of this file only
   - under the terms of either the GPL or the LGPL, and not to allow others to
   - use your version of this file under the terms of the MPL, indicate your
   - decision by deleting the provisions above and replace them with the notice
   - and other provisions required by the LGPL or the GPL. If you do not delete
   - the provisions above, a recipient may use your version of this file under
   - the terms of any one of the MPL, the GPL or the LGPL.
   -
   - ***** END LICENSE BLOCK ***** -->

<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:hs="http://www.firedictionary.com/history">
  <xsl:param name="enable">false</xsl:param>
  
  <xsl:template match="/">
    <table class="page-sidebar">
      <tr>
        <td class="sidebar-title-stretchable" onclick="streachSidebar()">Control Panel</td>
      </tr>
      <xsl:if test="$enable='true'">
        <tr>
          <td class="controlpanel">
            color : 
            <form name="form" id="form-color"> 
              <select name="color" onChange="setColor(form.color.value)"> 
                <option value="history-default.css">default</option>
                <option value="history-cream.css">cream</option>
              </select> 
            </form>
        
            style : 
            <form name="form2" id="form-style"> 
              <select name="style" onChange="setStyle(form2.style.value)"> 
                <option value="main/history-Words-and-Excerpts.xsl">default</option>
                <option value="main/history-Words-Definitions.xsl">words - definitions</option>
                <option value="main/history-Words.xsl">words</option>
                <option value="main/history-Definitions.xsl">definitions</option>
                <option value="main/history-Words-cvs.xsl">csv</option>
              </select> 
            </form>
    
          </td>
        </tr>
      </xsl:if>
    </table>
  </xsl:template>

</xsl:stylesheet>